function calculateReciprocity(obj,N)
%CALCULATERECIPROCITY Show the most reciprocal and least reciprocal
%connections in AdjacencyMatrix obj
%   calculateReciprocity(adjMat,N) will show the N most reciprocal and the
%       N least reciprocal connections in AdjacencyMatrix adjMat.
if nargin == 1
    N = 20;
end


[A labels] = getSquareMatrix(obj);
%clear self-loops
A(logical(eye(size(A)))) = 0;


% R = abs(A-A');   %./(A+A');
% Avgs = (A+A')./2;
% 
% [vals idxs] = sort(R(:),'descend');
% 
% [I J] = ind2sub(size(R),idxs);
% 
% disp('Most one-sided connections');
% for i = 1:40
%     fprintf('%s --> %s\t%u\n',labels{I(i)},labels{J(i)},A(I(i),J(i)));
%     if mod(i,2) == 0, fprintf('\n')
%     end
% end

R = zeros(size(A));
oneSidedness = @(x,y) (max(x,y).*exp(-.5.*min(x,y)));
% oneSidedness = @(x,y)(abs(x-y));

for i = 1:size(A,1)
    for j = i:size(A,2)
        R(i,j) = oneSidedness(A(i,j),A(j,i));
    end
end
R(isnan(R)) = 0;

[vals idxs] = sort(R(:),'descend');

[I J] = ind2sub(size(R),idxs);

fprintf('\n\nLeast reciprocal connections\n');
for i = 1:N
    fprintf('%s --> %s\t%u\n',labels{I(i)},labels{J(i)},A(I(i),J(i)));
    fprintf('%s --> %s\t%u\n',labels{J(i)},labels{I(i)},A(J(i),I(i)));
    fprintf('\n')
end

% Now find most reciprocal connections
R = zeros(size(A));
recpr = @(x,y)(min(x,y)*exp(-(abs(x-y)/(x+y))));
for i = 1:size(A,1)
    for j = i:size(A,2)
        R(i,j) = recpr(A(i,j),A(j,i));
    end
end
R(isnan(R)) = 0;

[vals idxs] = sort(R(:),'descend');

[I J] = ind2sub(size(R),idxs);

fprintf('\n\nMost reciprocal connections\n');
for i = 1:N
    fprintf('%s --> %s\t%u\n',labels{I(i)},labels{J(i)},A(I(i),J(i)));
    fprintf('%s --> %s\t%u\n',labels{J(i)},labels{I(i)},A(J(i),I(i)));
    fprintf('\n')
end
end

